/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import processing.xml.XMLElement;
import processing.xml.XMLParseException;

public class StdXMLBuilder {
    private Stack<XMLElement> stack;
    private XMLElement root;
    private XMLElement parent;

    public StdXMLBuilder() {
        this.stack = null;
        this.root = null;
    }

    public StdXMLBuilder(XMLElement parent) {
        this.parent = parent;
    }

    protected void finalize() throws Throwable {
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    public void startBuilding(String systemID, int lineNr) {
        this.stack = new Stack();
        this.root = null;
    }

    public void newProcessingInstruction(String target, Reader reader) {
    }

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
        String fullName = name;
        if (nsPrefix != null) {
            fullName = String.valueOf(nsPrefix) + ':' + name;
        }
        if (this.stack.empty()) {
            this.parent.set(fullName, nsURI, systemID, lineNr);
            this.stack.push(this.parent);
            this.root = this.parent;
        } else {
            XMLElement top = this.stack.peek();
            XMLElement elt = new XMLElement(fullName, nsURI, systemID, lineNr);
            top.addChild(elt);
            this.stack.push(elt);
        }
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
    }

    public void endElement(String name, String nsPrefix, String nsURI) {
        XMLElement child;
        XMLElement elt = this.stack.pop();
        if (elt.getChildCount() == 1 && (child = elt.getChildAtIndex(0)).getLocalName() == null) {
            elt.setContent(child.getContent());
            elt.removeChildAtIndex(0);
        }
    }

    public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
        XMLElement top;
        String fullName = key;
        if (nsPrefix != null) {
            fullName = String.valueOf(nsPrefix) + ':' + key;
        }
        if ((top = this.stack.peek()).hasAttribute(fullName)) {
            throw new XMLParseException(top.getSystemID(), top.getLineNr(), "Duplicate attribute: " + key);
        }
        if (nsPrefix != null) {
            top.setAttribute(fullName, nsURI, value);
        } else {
            top.setAttribute(fullName, value);
        }
    }

    public void addPCData(Reader reader, String systemID, int lineNr) {
        int bufSize = 2048;
        int sizeRead = 0;
        StringBuffer str = new StringBuffer(bufSize);
        char[] buf = new char[bufSize];
        while (true) {
            int size;
            if (sizeRead >= bufSize) {
                str.ensureCapacity(bufSize *= 2);
            }
            try {
                size = reader.read(buf);
            }
            catch (IOException e) {
                break;
            }
            if (size < 0) break;
            str.append(buf, 0, size);
            sizeRead += size;
        }
        XMLElement elt = new XMLElement(null, null, systemID, lineNr);
        elt.setContent(str.toString());
        if (!this.stack.empty()) {
            XMLElement top = this.stack.peek();
            top.addChild(elt);
        }
    }

    public Object getResult() {
        return this.root;
    }
}

