/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Hashtable;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class PShapeOBJ
extends PShape {
    public PShapeOBJ(PApplet parent, String filename) {
        this(parent, parent.createReader(filename));
    }

    public PShapeOBJ(PApplet parent, BufferedReader reader) {
        ArrayList<OBJFace> faces = new ArrayList<OBJFace>();
        ArrayList<OBJMaterial> materials = new ArrayList<OBJMaterial>();
        ArrayList<PVector> coords = new ArrayList<PVector>();
        ArrayList<PVector> normals = new ArrayList<PVector>();
        ArrayList<PVector> texcoords = new ArrayList<PVector>();
        PShapeOBJ.parseOBJ(parent, reader, faces, materials, coords, normals, texcoords);
        parent = null;
        this.family = 0;
        this.addChildren(faces, materials, coords, normals, texcoords);
    }

    protected PShapeOBJ(OBJFace face, OBJMaterial mtl, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        this.family = 3;
        this.kind = face.vertIdx.size() == 3 ? 9 : (face.vertIdx.size() == 4 ? 17 : 20);
        this.fillColor = PShapeOBJ.rgbaValue(mtl.kd);
        this.ambientColor = PShapeOBJ.rgbaValue(mtl.ka);
        this.specularColor = PShapeOBJ.rgbaValue(mtl.ks);
        this.shininess = mtl.ns;
        if (mtl.kdMap != null) {
            this.tintColor = PShapeOBJ.rgbaValue(mtl.kd, mtl.d);
        }
        this.vertexCount = face.vertIdx.size();
        this.vertices = new float[this.vertexCount][12];
        for (int j = 0; j < face.vertIdx.size(); ++j) {
            int texIdx;
            int normIdx;
            PVector norms = null;
            PVector vert = null;
            int vertIdx = face.vertIdx.get(j) - 1;
            vert = coords.get(vertIdx);
            if (j < face.normIdx.size() && -1 < (normIdx = face.normIdx.get(j) - 1)) {
                norms = normals.get(normIdx);
            }
            this.vertices[j][0] = vert.x;
            this.vertices[j][1] = vert.y;
            this.vertices[j][2] = vert.z;
            this.vertices[j][3] = mtl.kd.x;
            this.vertices[j][5] = mtl.kd.y;
            this.vertices[j][4] = mtl.kd.z;
            this.vertices[j][6] = 1.0f;
            if (norms != null) {
                this.vertices[j][9] = norms.x;
                this.vertices[j][10] = norms.y;
                this.vertices[j][11] = norms.z;
            }
            if (mtl == null || mtl.kdMap == null) continue;
            PVector tex = null;
            if (j < face.texIdx.size() && -1 < (texIdx = face.texIdx.get(j) - 1)) {
                tex = texcoords.get(texIdx);
            }
            this.image = mtl.kdMap;
            if (tex == null) continue;
            this.vertices[j][7] = tex.x;
            this.vertices[j][8] = tex.y;
        }
    }

    protected void addChildren(ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        int mtlIdxCur = -1;
        OBJMaterial mtl = null;
        for (int i = 0; i < faces.size(); ++i) {
            OBJFace face = faces.get(i);
            if (mtlIdxCur != face.matIdx) {
                mtlIdxCur = PApplet.max(0, face.matIdx);
                mtl = materials.get(mtlIdxCur);
            }
            PShapeOBJ child = new PShapeOBJ(face, mtl, coords, normals, texcoords);
            this.addChild(child);
        }
    }

    protected static void parseOBJ(PApplet parent, BufferedReader reader, ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        Hashtable<String, Integer> mtlTable = new Hashtable<String, Integer>();
        int mtlIdxCur = -1;
        try {
            String line;
            boolean readvt = false;
            boolean readvn = false;
            boolean readv = false;
            String gname = "object";
            while ((line = reader.readLine()) != null) {
                PVector tempv;
                while (line.contains("\\")) {
                    line = line.split("\\\\")[0];
                    String s = reader.readLine();
                    if (s == null) continue;
                    line = line + s;
                }
                String[] parts = line.split("\\s+");
                if (parts.length <= 0) continue;
                if (parts[0].equals("v")) {
                    tempv = new PVector(Float.valueOf(parts[1]).floatValue(), Float.valueOf(parts[2]).floatValue(), Float.valueOf(parts[3]).floatValue());
                    coords.add(tempv);
                    readv = true;
                    continue;
                }
                if (parts[0].equals("vn")) {
                    PVector tempn = new PVector(Float.valueOf(parts[1]).floatValue(), Float.valueOf(parts[2]).floatValue(), Float.valueOf(parts[3]).floatValue());
                    normals.add(tempn);
                    readvn = true;
                    continue;
                }
                if (parts[0].equals("vt")) {
                    tempv = new PVector(Float.valueOf(parts[1]).floatValue(), 1.0f - Float.valueOf(parts[2]).floatValue());
                    texcoords.add(tempv);
                    readvt = true;
                    continue;
                }
                if (parts[0].equals("o")) continue;
                if (parts[0].equals("mtllib")) {
                    BufferedReader mreader;
                    if (parts[1] == null || (mreader = parent.createReader(parts[1])) == null) continue;
                    PShapeOBJ.parseMTL(parent, mreader, materials, mtlTable);
                    continue;
                }
                if (parts[0].equals("g")) {
                    gname = 1 < parts.length ? parts[1] : "";
                    continue;
                }
                if (parts[0].equals("usemtl")) {
                    if (parts[1] == null) continue;
                    String mtlname = parts[1];
                    if (mtlTable.containsKey(mtlname)) {
                        Integer tempInt = mtlTable.get(mtlname);
                        mtlIdxCur = tempInt;
                        continue;
                    }
                    mtlIdxCur = -1;
                    continue;
                }
                if (!parts[0].equals("f")) continue;
                OBJFace face = new OBJFace();
                face.matIdx = mtlIdxCur;
                face.name = gname;
                for (int i = 1; i < parts.length; ++i) {
                    String seg = parts[i];
                    if (seg.indexOf("/") > 0) {
                        String[] forder = seg.split("/");
                        if (forder.length > 2) {
                            if (forder[0].length() > 0 && readv) {
                                face.vertIdx.add(Integer.valueOf(forder[0]));
                            }
                            if (forder[1].length() > 0 && readvt) {
                                face.texIdx.add(Integer.valueOf(forder[1]));
                            }
                            if (forder[2].length() <= 0 || !readvn) continue;
                            face.normIdx.add(Integer.valueOf(forder[2]));
                            continue;
                        }
                        if (forder.length > 1) {
                            if (forder[0].length() > 0 && readv) {
                                face.vertIdx.add(Integer.valueOf(forder[0]));
                            }
                            if (forder[1].length() <= 0) continue;
                            if (readvt) {
                                face.texIdx.add(Integer.valueOf(forder[1]));
                                continue;
                            }
                            if (!readvn) continue;
                            face.normIdx.add(Integer.valueOf(forder[1]));
                            continue;
                        }
                        if (forder.length <= 0 || forder[0].length() <= 0 || !readv) continue;
                        face.vertIdx.add(Integer.valueOf(forder[0]));
                        continue;
                    }
                    if (seg.length() <= 0 || !readv) continue;
                    face.vertIdx.add(Integer.valueOf(seg));
                }
                faces.add(face);
            }
            if (materials.size() == 0) {
                OBJMaterial defMtl = new OBJMaterial();
                materials.add(defMtl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void parseMTL(PApplet parent, BufferedReader reader, ArrayList<OBJMaterial> materials, Hashtable<String, Integer> materialsHash) {
        try {
            String line;
            OBJMaterial currentMtl = null;
            while ((line = reader.readLine()) != null) {
                String[] parts = (line = line.trim()).split("\\s+");
                if (parts.length <= 0) continue;
                if (parts[0].equals("newmtl")) {
                    String mtlname = parts[1];
                    currentMtl = new OBJMaterial(mtlname);
                    materialsHash.put(mtlname, new Integer(materials.size()));
                    materials.add(currentMtl);
                    continue;
                }
                if (parts[0].equals("map_Kd") && parts.length > 1) {
                    String texname = parts[1];
                    currentMtl.kdMap = parent.loadImage(texname);
                    continue;
                }
                if (parts[0].equals("Ka") && parts.length > 3) {
                    currentMtl.ka.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.ka.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.ka.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if (parts[0].equals("Kd") && parts.length > 3) {
                    currentMtl.kd.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.kd.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.kd.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if (parts[0].equals("Ks") && parts.length > 3) {
                    currentMtl.ks.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.ks.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.ks.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if ((parts[0].equals("d") || parts[0].equals("Tr")) && parts.length > 1) {
                    currentMtl.d = Float.valueOf(parts[1]).floatValue();
                    continue;
                }
                if (!parts[0].equals("Ns") || parts.length <= 1) continue;
                currentMtl.ns = Float.valueOf(parts[1]).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static int rgbaValue(PVector color) {
        return 0xFF000000 | (int)(color.x * 255.0f) << 16 | (int)(color.y * 255.0f) << 8 | (int)(color.z * 255.0f);
    }

    protected static int rgbaValue(PVector color, float alpha) {
        return (int)(alpha * 255.0f) << 24 | (int)(color.x * 255.0f) << 16 | (int)(color.y * 255.0f) << 8 | (int)(color.z * 255.0f);
    }

    protected static class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String name) {
            this.name = name;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }

    protected static class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }
}

