/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.screen.sceneGraph.aefreedman.grid;

import java.util.ArrayList;
import java.util.List;
import madparker.gametools.screen.sceneGraph.SceneGraphElement;
import madparker.gametools.screen.sceneGraph.aefreedman.grid.GridHandler;
import processing.core.PApplet;
import processing.core.PVector;

public class GridPosition
extends SceneGraphElement {
    private boolean debugDraw = false;
    private int backgroundColor;
    private int occupiedColor;
    public int size = 0;
    public float drawSize = 0.0f;
    public boolean passOverAnimationTriggered = false;
    private float colorLerpAmt = 0.0f;
    private float sizeLerpAmt = 0.0f;
    public List<GridPosition> adjacentGridPositions = new ArrayList<GridPosition>();
    private GridHandler gridHandler = null;
    public GridPosition up = null;
    public GridPosition down = null;
    public GridPosition left = null;
    public GridPosition right = null;
    public GridPosition upLeft = null;
    public GridPosition upRight = null;
    public GridPosition downLeft = null;
    public GridPosition downRight = null;
    public boolean edge = false;
    private boolean pointEdgesAtThemselves = true;

    public GridPosition(PVector position, GridHandler handler, boolean wrapEdges, int size, float sizeLerpAmt, int backgroundColor, float colorLerpAmt) {
        this.setup(position, handler, wrapEdges, size, sizeLerpAmt, backgroundColor, colorLerpAmt);
    }

    public GridPosition(PVector position, GridHandler handler, int size, float sizeLerpAmt, int backgroundColor, float colorLerpAmt) {
        this.setup(position, handler, true, size, sizeLerpAmt, backgroundColor, colorLerpAmt);
    }

    public void setup(PVector position, GridHandler handler, boolean wrapEdges, int size, float sizeLerpAmt, int backgroundColor, float colorLerpAmt) {
        super.setup();
        this.pointEdgesAtThemselves = wrapEdges;
        this.backgroundColor = backgroundColor;
        this.occupiedColor = pApplet.color(50, 255, 50, 55);
        this.position.set(position);
        this.gridHandler = handler;
        this.size = size;
        this.drawSize = 0.0f;
        this.debugDraw = false;
        this.sizeLerpAmt = sizeLerpAmt;
        this.colorLerpAmt = colorLerpAmt;
    }

    public void resetAnimation() {
        this.color = this.backgroundColor;
        this.drawSize = 0.0f;
    }

    @Override
    public void update() {
        super.update();
        this.updatePassOverAnimation();
        if (this.passOverAnimationTriggered) {
            this.passOverAnimationTriggered = false;
        }
    }

    @Override
    public void draw() {
        super.draw();
        pApplet.pushStyle();
        pApplet.noStroke();
        pApplet.noFill();
        this.drawPassOverAnimation();
        if (this.debugDraw) {
            pApplet.stroke(pApplet.color(200, 0, 200, 55));
            pApplet.noFill();
            pApplet.rectMode(0);
            pApplet.rect(0.0f, 0.0f, this.size, this.size);
            if (!this.children.isEmpty()) {
                pApplet.fill(this.occupiedColor);
                pApplet.rectMode(0);
                pApplet.rect(0.0f, 0.0f, this.size, this.size);
            }
        }
        pApplet.popStyle();
    }

    public void getAdjacentPositions() {
        if (this.position.x < (float)(pApplet.getWidth() - this.size)) {
            this.right = this.gridHandler.getGridPositionAtPoint(new PVector(this.position.x + (float)this.size, this.position.y));
            this.adjacentGridPositions.add(this.right);
        } else {
            this.edge = true;
            if (this.pointEdgesAtThemselves) {
                this.right = this;
                this.adjacentGridPositions.add(this.right);
            }
        }
        if (this.position.x >= (float)this.size) {
            this.left = this.gridHandler.getGridPositionAtPoint(new PVector(this.position.x - (float)this.size, this.position.y));
            this.adjacentGridPositions.add(this.left);
        } else {
            this.edge = true;
            if (this.pointEdgesAtThemselves) {
                this.left = this;
                this.adjacentGridPositions.add(this.left);
            }
        }
        if (this.position.y > 0.0f) {
            this.up = this.gridHandler.getGridPositionAtPoint(new PVector(this.position.x, this.position.y - (float)this.size));
            this.adjacentGridPositions.add(this.up);
        } else {
            this.edge = true;
            if (this.pointEdgesAtThemselves) {
                this.up = this;
                this.adjacentGridPositions.add(this.up);
            }
        }
        if (this.position.y < (float)(pApplet.getHeight() - this.size)) {
            this.down = this.gridHandler.getGridPositionAtPoint(new PVector(this.position.x, this.position.y + (float)this.size));
            this.adjacentGridPositions.add(this.down);
        } else {
            this.edge = true;
            if (this.pointEdgesAtThemselves) {
                this.down = this;
                this.adjacentGridPositions.add(this.down);
            }
        }
    }

    public void getAdjacentDiagonalPositions() {
        this.upLeft = this.up.left;
        this.upRight = this.up.right;
        this.downLeft = this.down.left;
        this.downRight = this.down.right;
        this.adjacentGridPositions.add(this.upLeft);
        this.adjacentGridPositions.add(this.upRight);
        this.adjacentGridPositions.add(this.downLeft);
        this.adjacentGridPositions.add(this.downRight);
    }

    public boolean isDebugDraw() {
        return this.debugDraw;
    }

    public void setDebugDraw(boolean debugDraw) {
        this.debugDraw = debugDraw;
    }

    public void passOverAnimationTrigger() {
        this.passOverAnimationTrigger(200.0f, 200.0f, 200.0f, 255.0f);
    }

    public void passOverAnimationTrigger(float r, float g, float b, float a) {
        this.setColor(r, g, b, a);
        this.drawSize = this.size;
        this.passOverAnimationTriggered = true;
    }

    public void passOverAnimationTrigger(int color) {
        this.passOverAnimationTrigger(pApplet.red(color), pApplet.green(color), pApplet.blue(color), pApplet.alpha(color));
    }

    public void updateAnimationSpeed(float sizeLerpAmt, float colorLerpAmt) {
        this.sizeLerpAmt = sizeLerpAmt;
        this.colorLerpAmt = colorLerpAmt;
    }

    private void drawPassOverAnimation() {
        pApplet.noStroke();
        pApplet.fill(this.color);
        pApplet.rectMode(3);
        pApplet.rect(this.size / 2, this.size / 2, this.drawSize, this.drawSize);
    }

    private void updatePassOverAnimation() {
        this.color = pApplet.lerpColor(this.color, this.backgroundColor, this.colorLerpAmt / GridPosition.pApplet.frameRate);
        this.drawSize = (double)this.drawSize < 0.5 ? 0.0f : PApplet.lerp(this.drawSize, 0.0f, this.sizeLerpAmt / GridPosition.pApplet.frameRate);
    }
}

