/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.animation;

import madparker.gametools.GameTemplate;
import madparker.gametools.animation.ProgressAnimation;
import madparker.gametools.screen.Screen;

public abstract class CrossFadeActionAnimation
extends ProgressAnimation {
    public GameTemplate game;
    public Screen currentScreen;
    public boolean doAction;

    public void trigger(GameTemplate game, Screen currentScreen, int duration) {
        super.trigger();
        this.game = game;
        this.currentScreen = currentScreen;
        this.duration = duration;
        this.doAction = true;
    }

    @Override
    protected void executeBegin() {
    }

    @Override
    protected void step() {
        if (this.percent < 0.5f) {
            this.currentScreen.foregroundFadeAlpha = 255.0f * this.percent * 2.0f;
        } else if (this.doAction) {
            this.doAction = false;
            this.currentScreen.foregroundFadeAlpha = 255.0f;
            this.action();
        }
        if (!this.doAction) {
            this.currentScreen.foregroundFadeAlpha = 255.0f * (1.0f - (this.percent - 0.5f) * 2.0f);
        }
    }

    public abstract void action();

    @Override
    protected void executeEnd() {
        this.currentScreen.foregroundFadeAlpha = 0.0f;
    }
}

