/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools;

import processing.core.PApplet;

public class PlatformerExample
extends PApplet {
    final int WIDTH = 30;
    final int HEIGHT = 23;
    int[][] level = new int[23][30];
    Player p1;
    boolean right = false;
    boolean left = false;
    boolean up = false;

    @Override
    public void setup() {
        this.size(480, 368);
        this.p1 = new Player(240, 184);
    }

    @Override
    public void draw() {
        this.p1.update();
        this.background(200);
        this.drawLevel();
        this.p1.show();
    }

    public void drawLevel() {
        this.fill(0);
        this.noStroke();
        int ix = 0;
        while (ix < 30) {
            int iy = 0;
            while (iy < 23) {
                switch (this.level[iy][ix]) {
                    case 1: {
                        this.rect(ix * 16, iy * 16, 16.0f, 16.0f);
                    }
                }
                ++iy;
            }
            ++ix;
        }
    }

    public boolean place_free(int xx, int yy) {
        yy = PApplet.parseInt(PlatformerExample.floor((float)yy / 16.0f));
        return (xx = PApplet.parseInt(PlatformerExample.floor((float)xx / 16.0f))) > -1 && xx < this.level[0].length && yy > -1 && yy < this.level.length && this.level[yy][xx] == 0;
    }

    @Override
    public void keyPressed() {
        switch (this.keyCode) {
            case 39: {
                this.left = true;
                break;
            }
            case 37: {
                this.right = true;
                break;
            }
            case 38: {
                this.up = true;
            }
        }
    }

    @Override
    public void keyReleased() {
        switch (this.keyCode) {
            case 39: {
                this.left = false;
                break;
            }
            case 37: {
                this.right = false;
                break;
            }
            case 38: {
                this.up = false;
            }
        }
    }

    @Override
    public void mousePressed() {
        if (this.mouseButton == 37) {
            int[] nArray = this.level[PApplet.parseInt(PlatformerExample.floor((float)this.mouseY / 16.0f))];
            int n = PApplet.parseInt(PlatformerExample.floor((float)this.mouseX / 16.0f));
            nArray[n] = nArray[n] ^ 1;
        }
    }

    public static void main(String[] args) {
        PApplet.main(new String[]{"--bgcolor=#F0F0F0", PlatformerExample.class.getName()});
    }

    class Player {
        int x;
        int y;
        float xSpeed;
        float ySpeed;
        float accel;
        float deccel;
        float maxXspd;
        float maxYspd;
        float xSave;
        float ySave;
        int xRep;
        int yRep;
        float gravity;

        Player(int _x, int _y) {
            this.x = _x;
            this.y = _y;
            this.xSpeed = 0.0f;
            this.ySpeed = 0.0f;
            this.accel = 0.5f;
            this.deccel = 0.5f;
            this.maxXspd = 2.0f;
            this.maxYspd = 12.0f;
            this.xSave = 0.0f;
            this.ySave = 0.0f;
            this.xRep = 0;
            this.yRep = 0;
            this.gravity = 0.25f;
        }

        public void update() {
            int offsetY;
            if (PlatformerExample.this.right) {
                this.xSpeed += this.accel;
                if (this.xSpeed > this.maxXspd) {
                    this.xSpeed = this.maxXspd;
                }
            } else if (PlatformerExample.this.left) {
                this.xSpeed -= this.accel;
                if (this.xSpeed < -this.maxXspd) {
                    this.xSpeed = -this.maxXspd;
                }
            } else if (this.xSpeed > 0.0f) {
                this.xSpeed -= this.deccel;
                if (this.xSpeed < 0.0f) {
                    this.xSpeed = 0.0f;
                }
            } else if (this.xSpeed < 0.0f) {
                this.xSpeed += this.deccel;
                if (this.xSpeed > 0.0f) {
                    this.xSpeed = 0.0f;
                }
            }
            if (!(!PlatformerExample.this.up || PlatformerExample.this.place_free(this.x, this.y + 16) && PlatformerExample.this.place_free(this.x + 15, this.y + 16))) {
                this.ySpeed = -5.3f;
            }
            this.ySpeed += this.gravity;
            this.xRep = 0;
            this.yRep = 0;
            this.xRep += PlatformerExample.floor(PlatformerExample.abs(this.xSpeed));
            this.yRep += PlatformerExample.floor(PlatformerExample.abs(this.ySpeed));
            this.xSave += PlatformerExample.abs(this.xSpeed) - (float)PlatformerExample.floor(PlatformerExample.abs(this.xSpeed));
            this.ySave += PlatformerExample.abs(this.ySpeed) - (float)PlatformerExample.floor(PlatformerExample.abs(this.ySpeed));
            int signX = this.xSpeed < 0.0f ? -1 : 1;
            int signY = this.ySpeed < 0.0f ? -1 : 1;
            int offsetX = this.xSpeed < 0.0f ? 0 : 15;
            int n = offsetY = this.ySpeed < 0.0f ? 0 : 15;
            if (this.xSave >= 1.0f) {
                this.xSave -= 1.0f;
                ++this.xRep;
            }
            if (this.ySave >= 1.0f) {
                this.ySave -= 1.0f;
                ++this.yRep;
            }
            while (this.yRep > 0) {
                if (PlatformerExample.this.place_free(this.x, this.y + offsetY + signY) && PlatformerExample.this.place_free(this.x + 15, this.y + offsetY + signY)) {
                    this.y += signY;
                } else {
                    this.ySpeed = 0.0f;
                }
                --this.yRep;
            }
            while (this.xRep > 0) {
                if (PlatformerExample.this.place_free(this.x + offsetX + signX, this.y) && PlatformerExample.this.place_free(this.x + offsetX + signX, this.y + 15)) {
                    this.x += signX;
                } else {
                    this.xSpeed = 0.0f;
                }
                --this.xRep;
            }
        }

        public void show() {
            PlatformerExample.this.pushMatrix();
            PlatformerExample.this.fill(255.0f, 0.0f, 0.0f);
            PlatformerExample.this.noStroke();
            PlatformerExample.this.rect(this.x, this.y, 16.0f, 16.0f);
            PlatformerExample.this.popMatrix();
        }
    }
}

