/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util;

import com.jogamp.opengl.util.GLArrayDataEditable;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLArrayHandlerFlat;

public class GLArrayHandlerInterleaved
implements GLArrayHandler {
    private GLArrayDataEditable ad;
    private List<GLArrayHandlerFlat> subArrays = new ArrayList<GLArrayHandlerFlat>();

    public GLArrayHandlerInterleaved(GLArrayDataEditable gLArrayDataEditable) {
        this.ad = gLArrayDataEditable;
    }

    @Override
    public final void setSubArrayVBOName(int n) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).getData().setVBOName(n);
        }
    }

    @Override
    public final void addSubHandler(GLArrayHandlerFlat gLArrayHandlerFlat) {
        this.subArrays.add(gLArrayHandlerFlat);
    }

    private final void syncSubData(GL gL, boolean bl, boolean bl2, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).syncData(gL, bl, bl2, object);
        }
    }

    @Override
    public final void syncData(GL gL, boolean bl, Object object) {
        if (bl) {
            Buffer buffer = this.ad.getBuffer();
            if (this.ad.isVBO()) {
                gL.glBindBuffer(this.ad.getVBOTarget(), this.ad.getVBOName());
                if (!this.ad.isVBOWritten()) {
                    if (null != buffer) {
                        gL.glBufferData(this.ad.getVBOTarget(), buffer.limit() * this.ad.getComponentSizeInBytes(), buffer, this.ad.getVBOUsage());
                    }
                    this.ad.setVBOWritten(true);
                }
            }
            this.syncSubData(gL, true, true, object);
        } else {
            this.syncSubData(gL, false, true, object);
            if (this.ad.isVBO()) {
                gL.glBindBuffer(this.ad.getVBOTarget(), 0);
            }
        }
    }

    @Override
    public final void enableState(GL gL, boolean bl, Object object) {
        for (int i = 0; i < this.subArrays.size(); ++i) {
            this.subArrays.get(i).enableState(gL, bl, object);
        }
    }
}

