/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.GaspRange;
import jogamp.graph.font.typecast.ot.table.Table;

public class GaspTable
implements Table {
    private DirectoryEntry de;
    private int version;
    private int numRanges;
    private GaspRange[] gaspRange;

    protected GaspTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this.de = (DirectoryEntry)directoryEntry.clone();
        this.version = dataInput.readUnsignedShort();
        this.numRanges = dataInput.readUnsignedShort();
        this.gaspRange = new GaspRange[this.numRanges];
        for (int i = 0; i < this.numRanges; ++i) {
            this.gaspRange[i] = new GaspRange(dataInput);
        }
    }

    @Override
    public int getType() {
        return 1734439792;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'gasp' Table - Grid-fitting And Scan-conversion Procedure\n---------------------------------------------------------");
        stringBuffer.append("\n  'gasp' version:      ").append(this.version);
        stringBuffer.append("\n  numRanges:           ").append(this.numRanges);
        for (int i = 0; i < this.numRanges; ++i) {
            stringBuffer.append("\n\n  gasp Range ").append(i).append("\n");
            stringBuffer.append(this.gaspRange[i].toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this.de;
    }
}

