/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.cache.TempJarCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import jogamp.common.Debug;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    private static final HashSet<String> loaded;
    private static LoaderAction loaderAction;
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase: Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    public static final boolean addNativeJarLibs(Class<?> clazz, String string) {
        block5: {
            if (TempJarCache.isInitialized()) {
                String string2 = string + "-natives-" + Platform.getOSAndArch() + ".jar";
                ClassLoader classLoader = clazz.getClassLoader();
                try {
                    URL uRL = JarUtil.getURLDirname(JarUtil.getJarSubURL(clazz.getName(), classLoader));
                    if (DEBUG) {
                        System.err.println("JNILibLoaderBase: addNativeJarLibs: " + string + ": url-root " + uRL);
                    }
                    URL uRL2 = JarUtil.getJarFileURL(uRL, string2);
                    if (DEBUG) {
                        System.err.println("JNILibLoaderBase: addNativeJarLibs: " + string + ": nativeJarURL " + uRL2);
                    }
                    TempJarCache.addNativeLibs(clazz, uRL2, classLoader);
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Catched: " + exception.getMessage());
                    if (!DEBUG) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean addNativeJarLibs(Class<?> clazz, String string, String[] stringArray) {
        boolean bl;
        block7: {
            bl = false;
            if (TempJarCache.isInitialized()) {
                ClassLoader classLoader = clazz.getClassLoader();
                try {
                    String string2 = JarUtil.getJarBasename(clazz.getName(), classLoader);
                    if (string2 != null) {
                        if (!bl && null != string) {
                            bl = JNILibLoaderBase.addNativeJarLibs(clazz, string);
                        }
                        if (!bl && null != stringArray) {
                            bl = true;
                            for (int i = 0; bl && i < stringArray.length; ++i) {
                                String string3 = stringArray[i];
                                if (null == string3 || string3.length() <= 0) continue;
                                bl = JNILibLoaderBase.addNativeJarLibs(clazz, string3);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Catched: " + exception.getMessage());
                    if (!DEBUG) break block7;
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl);
        }
    }

    private static void loadLibraryInternal(String string) {
        if (null != customLoadLibraryMethod && !string.equals("jawt")) {
            try {
                customLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + string).initCause(exception);
            }
        } else {
            if (TempJarCache.isInitialized()) {
                String string2 = TempJarCache.findLibrary(string);
                if (null != string2) {
                    if (DEBUG) {
                        System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + ") -> System.load(" + string2 + ") (TempJarCache)");
                    }
                    System.load(string2);
                    return;
                }
                if (DEBUG) {
                    System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + ") -> TempJarCache not mapped");
                }
            }
            if (DEBUG) {
                System.err.println("JNILibLoaderBase: loadLibraryInternal(" + string + ") -> System.loadLibrary(" + string + ")");
            }
            System.loadLibrary(string);
        }
    }

    static {
        Method method;
        DEBUG = Debug.debug("JNILibLoader");
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        customLoadLibraryMethod = method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                String string;
                boolean bl = Debug.getBooleanProperty("sun.jnlp.applet.launcher", true);
                Class<?> clazz = null;
                Method method = null;
                if (bl) {
                    try {
                        clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("JNILibLoaderBase: <org.jdesktop.applet.util.JNLPAppletLauncher> not found, despite enabled property <sun.jnlp.applet.launcher>, JNLPAppletLauncher was probably used before");
                        System.setProperty("sun.jnlp.applet.launcher", Boolean.FALSE.toString());
                    }
                    catch (LinkageError linkageError) {
                        throw linkageError;
                    }
                    if (null != clazz) {
                        try {
                            method = clazz.getDeclaredMethod("loadLibrary", String.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (DEBUG) {
                                noSuchMethodException.printStackTrace();
                            }
                            clazz = null;
                        }
                    }
                }
                if (null == clazz && null != (string = PropertyAccess.getProperty("jnlp.launcher.class", false, null))) {
                    try {
                        clazz = Class.forName(string);
                        method = clazz.getDeclaredMethod("loadLibrary", String.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (DEBUG) {
                            classNotFoundException.printStackTrace();
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (DEBUG) {
                            noSuchMethodException.printStackTrace();
                        }
                        clazz = null;
                    }
                }
                return method;
            }
        });
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        @Override
        public boolean loadLibrary(String string, boolean bl) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(string);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            System.err.println("JNILibLoaderBase: loaded " + string);
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        @Override
        public void loadLibrary(String string, String[] stringArray, boolean bl) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl);
                    }
                }
                this.loadLibrary(string, false);
            }
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2);

        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

